/*
** Source Lines of Code Counter         (c) Copyright IBM Corp., 1987, 1992
**                                      For Internal Use Only
**    by: Jeffrey W. Hamilton  (JEFFH at YKTVMH)
*/
#include "global.h"

int debug = 0;
int recurse = 0;
char *profile_fn;
char *input_fn = NULL;
char *output_fn = NULL;
char *report_fn = NULL;
char *language = NULL;
char filename[100];

int main(int argc, char *argv[])
{
   FILE *input;
   FILE *profile;
   FILE *report;
   sym_list *list;
   register int i;
   char *env, *arg;

   /* Establish default file names */
#if defined(OS_DOS) || defined(OS_OS2) || defined(OS_AIX)
   profile_fn = "slocc.pro";
#elif defined(OS_MVS)
   profile_fn = "SLOCC.PROFILE";
#elif defined(OS_VM)
   profile_fn = "SLOCC.PROFILE.A";
#endif

#if defined(OS_DOS)
   setbuf(stdout,NULL);        /* standard output is unbuffered */
#endif

   /*
   ** Starting Banner
   */
   fprintf(stderr,"\nSource Lines of Code Counter - (c) Copyright IBM Corp., 1987, 1992\n");
   fprintf(stderr,"    for IBM Internal Use Only\n");
#if defined(OS_DOS)
   fprintf(stderr,"    Compiled for DOS.  SLOCC Version " VERSION ".\n");
#elif defined(OS_OS2)
   fprintf(stderr,"    Compiled for OS/2.  SLOCC Version " VERSION ".\n");
#elif defined(OS_VM)
   fprintf(stderr,"    Compiled for VM/CMS.  SLOCC Version " VERSION ".\n");
#elif defined(OS_MVS)
   fprintf(stderr,"    Compiled for MVS.  SLOCC Version " VERSION ".\n");
#elif defined(OS_AIX)
   fprintf(stderr,"    Compiled for AIX.  SLOCC Version " VERSION ".\n");
#else
   fprintf(stderr,"   ===========> Compiled without an operating system selected! <=============\n");
#endif
   fprintf(stderr,"    by Jeffrey W. Hamilton (JEFFH at YKTVMH)\n");


   /* Delivery Operating Instructions */
   if ((argc == 2) && (*argv[1] == '?')) {
      print_instructions(argv[0]);
      exit(0);
   }

   /*
   ** Process the parameters from the environment
   */
   detailed = 0;
   brief = 0;
   if ((env = getenv("SLOCC")) != NULL) {
     strcpy(buffer, env);
     for (arg = strtok(buffer, " "); arg != NULL; arg = strtok(NULL, " ")) {
       if (strcmpi(arg,"-d") == 0) {
         /* Request for a full detailed report */
         detailed = 1;
	 brief = 0;
       } else if (strcmp(arg,"-db") == 0) {
	 /* Request for a brief detailed report */
	 detailed = 1;
	 brief = 1;
       } else if (strcmp(arg,"-DEBUG") == 0) {
         /* Turn on debug trace. Note must be in uppercase */
         debug = 1;
       } else if (strcmpi(arg,"-o") == 0) {
         /* Change output from stdout to user's file */
	 if ((arg = strtok(NULL, " ")) != NULL) {
	   output_fn = strdup(arg);
         } else {
	   fprintf(stderr,"Missing ouput file name after option -o in environment variable SLOCC\n");
	   print_instructions(argv[0]);
	   exit(1);
         }
#ifdef OS_AIX
       } else if (strcmp(arg,"-r") == 0) {
         /* Change report file from default to user's file */
	 if ((arg = strtok(NULL, " ")) != NULL) {
	   report_fn = strdup(arg);
         } else {
	   fprintf(stderr,"Missing report template file name after option -r in environment variable SLOCC\n");
	   print_instructions(argv[0]);
	   exit(1);
         }
       } else if (strcmp(arg,"-R") == 0) {
	 /* Recursively search directories for files */
	 recurse = 1;
#else
       } else if (strcmpi(arg,"-r") == 0) {
         /* Change report file from default to user's file */
	 if ((arg = strtok(NULL, " ")) != NULL) {
	   report_fn = strdup(arg);
	 } else {
	   fprintf(stderr,"Missing report template file name after option -r in environment variable SLOCC\n");
	   print_instructions(argv[0]);
	   exit(1);
	 }
#endif
       } else if (strcmpi(arg,"-p") == 0) {
         /* Change profile from default to user's file */
	 if ((arg = strtok(NULL, " ")) != NULL) {
	   profile_fn = strdup(arg);
	 } else {
	   fprintf(stderr,"Missing profile file name after option -p in environment variable SLOCC\n");
	   print_instructions(argv[0]);
	   exit(1);
         }
       } else if (strcmpi(arg,"-i") == 0) {
         /* Change input source from stdin to given file */
	 if ((arg = strtok(NULL, " ")) != NULL) {
	   input_fn = strdup(arg);
	 } else {
	   fprintf(stderr,"Missing input file name after option -i in environment variable SLOCC\n");
	   print_instructions(argv[0]);
	   exit(1);
         }
       } else if (strcmpi(arg,"-l") == 0) {
         /* Force counting in a particular language */
	 if ((arg = strtok(NULL, " ")) != NULL) {
            language = strdup(arg);
	  } else {
            fprintf(stderr,"Missing language extension after option -l in environment variable SLOCC\n");
            print_instructions(argv[0]);
            exit(1);
	  }
       } else {
         fprintf(stderr,"%s is not a recognized option in environment variable SLOCC\n",arg);
         print_instructions(argv[0]);
         exit(1);
       }
     }
   }

   /*
   ** Process the parameters from the command line.
   */
   for (i = 1; i < argc; i++) {
#if 0
      strupr(argv[i]);
#endif
      if (strcmpi(argv[i],"-d") == 0) {
         /* Request for a full detailed report */
         detailed = 1;
	 brief = 0;
      } else if (strcmp(argv[i],"-db") == 0) {
	 /* Request a brief detailed report */
	 detailed = 1;
	 brief = 1;
      } else if (strcmp(argv[i],"-DEBUG") == 0) {
         /* Turn on debug trace. Note must be in uppercase */
         debug = 1;
      } else if (strcmpi(argv[i],"-o") == 0) {
         /* Change output from stdout to user's file */
         if (i < argc-1) {
            i++;
            output_fn = argv[i];
         } else {
            fprintf(stderr,"Missing ouput file name after option -o\n");
            print_instructions(argv[0]);
            exit(1);
         }
#ifdef OS_AIX
      } else if (strcmp(argv[i],"-r") == 0) {
         /* Change report file from default to user's file */
         if (i < argc-1) {
            i++;
            report_fn = argv[i];
         } else {
            fprintf(stderr,"Missing report template file name after option -r\n");
            print_instructions(argv[0]);
            exit(1);
         }
      } else if (strcmp(argv[i],"-R") == 0) {
	/* Recursively search directories for files */
	recurse = 1;
#else
      } else if (strcmpi(argv[i],"-r") == 0) {
         /* Change report file from default to user's file */
         if (i < argc-1) {
            i++;
            report_fn = argv[i];
         } else {
            fprintf(stderr,"Missing report template file name after option -r\n");
            print_instructions(argv[0]);
            exit(1);
         }
#endif
      } else if (strcmpi(argv[i],"-p") == 0) {
         /* Change profile from default to user's file */
         if (i < argc-1) {
            i++;
            profile_fn = argv[i];
         } else {
            fprintf(stderr,"Missing profile file name after option -p\n");
            print_instructions(argv[0]);
            exit(1);
         }
      } else if (strcmpi(argv[i],"-i") == 0) {
         /* Change input source from stdin to given file */
         if (i < argc-1) {
            i++;
            input_fn = argv[i];
         } else {
            fprintf(stderr,"Missing input file name after option -i\n");
            print_instructions(argv[0]);
            exit(1);
         }
      } else if (strcmpi(argv[i],"-l") == 0) {
         /* Force counting in a particular language */
         if (i < argc-1) {
            i++;
            language = argv[i];
         } else {
            fprintf(stderr,"Missing language extension after option -l\n");
            print_instructions(argv[0]);
            exit(1);
         }
      } else {
         fprintf(stderr,"%s is not a recognized option\n",argv[i]);
         print_instructions(argv[0]);
         exit(1);
      }
   }

   if (report_fn == NULL) {
      /* Assume the user only wants a detailed report */
      detailed = 1;
   }

   if (debug) {
      fprintf(stderr,"Options selected:\n");
      fprintf(stderr,"  Profile: %s\n",profile_fn);
      if (report_fn != NULL) {
         fprintf(stderr,"  Report Template: %s\n",report_fn);
      } else {
         fprintf(stderr,"  No report template selected\n");
      }
      if (input_fn != NULL) {
         fprintf(stderr,"  Input: %s\n",input_fn);
      } else {
         fprintf(stderr,"  Input: stdin\n");
      }
      if (output_fn != NULL) {
         fprintf(stderr,"  Output: %s\n",output_fn);
      } else {
         fprintf(stderr,"  Output: stdout\n");
      }
      if (language != NULL) {
         fprintf(stderr,"  Assume processing %s source files\n",language);
      }
      if (detailed) {
         fprintf(stderr,"  %s Detailed report\n",
		 (brief) ? "Brief" : "Full");
      }
      if (recurse) {
	 fprintf(stderr,"  Recursive input file searches\n");
      }
   }

   /* Open the output file */
   if (output_fn != NULL) {
      if ((output = fopen(output_fn,"w")) == NULL) {
         fprintf(stderr,"Unable to open output file for writing\n",output_fn);
         exit(1);
      }
   } else {
      output = stdout;
   }

   descr = NULL;
   counts = NULL;

   /*
   ** Process the profile
   */
   if ((profile = xfopen(profile_fn,"r")) == NULL) {
      fprintf(stderr,"Unable to open profile %s for reading\n",profile_fn);
      exit(1);
   }
   fprintf(stderr,"\nProcessing language description file.\n");
   build_profile(profile);
   fclose(profile);

   if (detailed && !brief) fprintf(output,"Detailed SLOCC Report\n");

   /*
   ** Gather files and count the lines
   */
   if (input_fn != NULL) {
      if ((input = xfopen(input_fn,"r")) == NULL) {
         fprintf(stderr,"Unable to open input file for reading\n",input_fn);
         exit(1);
      }
   } else {
      input = stdin;
      printf("\nEnter file name");
#if !defined(OS_MVS)
      printf(" (\"wildcard\" characters are allowed).\n");
#else
      printf(".\n");
#endif
      printf("Pressing enter without typing a file name will start the summary report.\n");
   }
   total_lines = total_comments = total_code = 0;
   do {
      if (input_fn == NULL) {
         printf("Filename: ");
         fflush(stdout);
      }
      fgets(filename, sizeof(filename),input);
      /* Remove trailing newline character */
      filename[strlen(filename)-1] = '\0';
      if (!feof(input)) {
         if (filename[0] == '\0') {
            /* No file name, assume this is the end of the input */
            break;
         }
         list = build_list(filename);
         while (list != NULL) {
            fprintf(stderr,"Counting source lines in %s\n",list->name);
            record_count(list);
            list = list->next;
         }
      } else {
        break;
      }
   } while (1);
   if (detailed && !brief) {
      /* Give an total summary at the end of the detailed report */
      fprintf(output,"\n   Total Number of Files: %u\n", total_files);
      fprintf(output,"   Actual Lines: %ld\n", total_lines);
      fprintf(output,"   Lines of Comments: %ld\n", total_comments);
      fprintf(output,"   Number of Statements: %ld\n", total_code);
      if (report_fn != NULL) {
         /* Put a form feed between the detailed report and the user's report */
         fprintf(output,"\f");
      }
   }

   /*
   ** Print the Summary Report
   */
   if (report_fn != NULL) {
      if ((report = xfopen(report_fn,"r")) == NULL) {
         fprintf(stderr,"Unable to open report template file for reading\n",report_fn);
         exit(1);
      }
      print_report(report);
      fclose(report);
   }

   return(0);
}

/*
** Give the user instructions on how to use this program.
*/
void print_instructions(char *progname)
{
   char drive[DISKNAME_LIMIT+1];
   char dir[PATHNAME_LIMIT+1];
   char filename[FILENAME_LIMIT+1];
   char extension[EXTENSION_LIMIT+2];


   fnsplit(progname, drive, dir, filename, extension);

   fprintf(stderr,"\nTo invoke:\n");
   fprintf(stderr,"   %s {-d} {-r report_file} {-i input_file} {-o output_file} {-p profile} {-l language} "
#if defined(OS_AIX)
	   "{-R} "
#endif
	   "{-DEBUG}\n",filename);
   fprintf(stderr,"\nOptions:\n");
   fprintf(stderr,"   -d := Include full detailed information in output\n");
   fprintf(stderr,"   -db:= Include brief detailed information in output\n");
   fprintf(stderr,"   -r := Name of output report template. Default is none\n");
#if defined(OS_AIX)
   fprintf(stderr,"   -R := Recursively apply filenames to all subdirectories\n");
#endif
   fprintf(stderr,"   -i := Source of file names to count. Default is to prompt user for the files\n");
   fprintf(stderr,"   -o := Place to send results. Default is the user's console\n");
   fprintf(stderr,"   -p := Name of SLOCC profile to use. Default is %s\n",
#if defined(OS_DOS) || defined(OS_OS2) || defined(OS_AIX)
           "slocc.pro");
#elif defined(OS_MVS)
           "SLOCC.PROFILE");
#elif defined(OS_VM)
           "SLOCC.PROFILE.A");
#endif
   fprintf(stderr,"   -DEBUG := Print internal details of counting process\n");
}

/*
** One stop shopping for making sure malloc returned a pointer.
*/
void check_space(void *pointer)
{
   if (pointer == NULL) {
      fprintf(stderr,"Insufficent memory\n");
      exit(3);
   }
}

#if defined(OS_MVS) || defined(OS_VM)
/*
** String Duplication
*/
char *strdup(char *string)
{
   register char *result;

   if (result = malloc(strlen(string)+1)) {
      strcpy(result,string);
   }
   return(result);
}
#endif

#if defined(OS_MVS) || defined(OS_VM) || defined(OS_AIX)
/*
** Convert string to uppercase
*/
char *strupr(char *string)
{
   register char *p;
   register int flag = 1;

   for (p = string; *p; p++) {
      *p = toupper(*p);
   }
   return(string);
}

/*
** Convert string to lowercase
*/
char *strlwr(char *string)
{
   register char *p;

   for (p = string; *p; p++) {
      *p = tolower(*p);
   }
   return(string);
}

/*
** Compare two strings (case insensitive)
*/
int strcmpi(char *s1, char *s2)
{
   while (*s1 || *s2) {
      if (!(*s1) || (toupper(*s1) < toupper(*s2))) {
         return(-1);
      } else if (!(*s1) || (toupper(*s1) > toupper(*s2))) {
         return(1);
      }
      s1++;
      s2++;
   }
   return(0);
}

/*
** Compare two strings (case insensitive) with limits
*/
int strncmpi(char *s1, char *s2, int limit)
{
   while ((*s1 || *s2) && (limit > 0)) {
      if (!(*s1) || (toupper(*s1) < toupper(*s2))) {
         return(-1);
      } else if (!(*s1) || (toupper(*s1) > toupper(*s2))) {
         return(1);
      }
      s1++;
      s2++;
      limit--;
   }
   return(0);
}
#endif

#if defined(OS_AIX1_2)
/*
** Do a safe move
*/
void *memmove(void *dest, void *src, int n)
{
   bcopy(src,dest,n);
   return dest;
}
#endif

